/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.mixin.minecraft.entity;

import Krasnodar.rockstarnew.Rockstar;
import Krasnodar.rockstarnew.systems.event.impl.game.EntityDeathEvent;
import Krasnodar.rockstarnew.systems.event.impl.game.EntityJumpEvent;
import Krasnodar.rockstarnew.systems.modules.modules.player.NoDelay;
import Krasnodar.rockstarnew.systems.modules.modules.player.NoPush;
import Krasnodar.rockstarnew.systems.modules.modules.visuals.SwingAnimation;
import Krasnodar.rockstarnew.utility.rotations.MoveCorrection;
import Krasnodar.rockstarnew.utility.rotations.RotationHandler;
import Krasnodar.rockstarnew.utility.rotations.RotationTask;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin {
    @Shadow
    private int field_6228;

    @Shadow
    public abstract void method_5650(class_1297.class_5529 var1);

    @Shadow
    public abstract class_1799 method_6047();

    @ModifyReturnValue(method={"method_6028()I"}, at={@At(value="RETURN")})
    public int replaceSwingSpeed(int original) {
        SwingAnimation swingAnimationModule = Rockstar.getInstance().getModuleManager().getModule(SwingAnimation.class);
        return swingAnimationModule.isEnabled() && swingAnimationModule.shouldApplyAnimation(this.method_6047()) ? (int)((float)original * Rockstar.getInstance().getSwingManager().getSpeed().getCurrentValue()) : original;
    }

    @Inject(method={"method_6043()V"}, at={@At(value="HEAD")}, cancellable=true)
    public void triggerJumpEvent(CallbackInfo ci) {
        class_1309 livingEntity = (class_1309)this;
        EntityJumpEvent event = new EntityJumpEvent(livingEntity);
        Rockstar.getInstance().getEventManager().triggerEvent(event);
        if (event.isCancelled()) {
            ci.cancel();
        }
    }

    @ModifyExpressionValue(method={"method_6043()V"}, at={@At(value="NEW", target="(DDD)Lnet/minecraft/class_243;")})
    public class_243 movementCorrection(class_243 original) {
        RotationHandler rotationHandler = Rockstar.INSTANCE.getRotationHandler();
        RotationTask currentTask = rotationHandler.getCurrentTask();
        if (this != class_310.method_1551().field_1724) {
            return original;
        }
        if (currentTask != null && currentTask.getMoveCorrection() != MoveCorrection.NONE) {
            float yaw = rotationHandler.getCurrentRotation().getYaw() * ((float)Math.PI / 180);
            return new class_243((double)(-class_3532.method_15374((float)yaw) * 0.2f), 0.0, (double)(class_3532.method_15362((float)yaw) * 0.2f));
        }
        return original;
    }

    @Inject(method={"method_6007()V"}, at={@At(value="HEAD")})
    public void removeJumpDelay(CallbackInfo ci) {
        NoDelay noDelay = Rockstar.getInstance().getModuleManager().getModule(NoDelay.class);
        if (noDelay.isEnabled() && noDelay.getJump().isEnabled()) {
            this.field_6228 = 0;
        }
    }

    @Inject(method={"method_5810()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void removePushFromEntity(CallbackInfoReturnable<Boolean> cir) {
        NoPush noPush = Rockstar.getInstance().getModuleManager().getModule(NoPush.class);
        class_1309 entity = (class_1309)this;
        if (entity instanceof class_746 && noPush.isEnabled() && noPush.getEntities().isSelected()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"method_6078(Lnet/minecraft/class_1282;)V"}, at={@At(value="TAIL")})
    public void triggerEntityDeathEvent(class_1282 damageSource, CallbackInfo ci) {
        class_1309 entity = (class_1309)this;
        Rockstar.getInstance().getEventManager().triggerEvent(new EntityDeathEvent(entity, damageSource));
    }

    @Redirect(method={"method_61430(Lnet/minecraft/class_243;)Lnet/minecraft/class_243;"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_1309;method_36455()F"))
    private float redirectGetPitch(class_1309 instance) {
        RotationHandler rotationHandler = Rockstar.getInstance().getRotationHandler();
        return rotationHandler.isIdling() ? instance.method_36455() : rotationHandler.getCurrentRotation().getPitch();
    }

    @Redirect(method={"method_61430(Lnet/minecraft/class_243;)Lnet/minecraft/class_243;"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_1309;method_5720()Lnet/minecraft/class_243;"))
    private class_243 redirectGetRotationVector(class_1309 instance) {
        RotationHandler rotationHandler = Rockstar.getInstance().getRotationHandler();
        return rotationHandler.isIdling() ? instance.method_5720() : rotationHandler.getCurrentRotation().getRotationVector();
    }
}

